import {stringify} from 'querystring';

import {prepareName} from './lib/core';
import {IAviaSearchParams} from 'helpers/project/avia/pages/SearchResultsPage/SearchResultsPage';

const SUITE_NAME_PREFIX = 'Авиабилеты';
const BASE_URL = '/avia/';

/**
 * Вернёт базовые параметры для страниц авиа
 */
const getBaseAviaSearchParams = ({
    from,
    to,
    travellers = {
        adults: 1,
        children: 0,
        infants: 0,
    },
    startDate,
    endDate = '',
    klass = 'economy',
}: IAviaSearchParams): string => {
    return stringify({
        fromId: from.id,
        fromName: from.name,
        toId: to.id,
        toName: to.name,
        when: startDate,
        return_date: endDate,
        oneway: endDate ? 2 : 1,
        klass,
        adult_seats: travellers.adults,
        children_seats: travellers.children,
        infant_seats: travellers.infants,
    });
};

export const index = {
    url: BASE_URL,
    name: prepareName(SUITE_NAME_PREFIX, 'Главная'),
};

export const serp = {
    url: (options: IAviaSearchParams): string => {
        const {filters} = options;
        const query = getBaseAviaSearchParams(options);

        return `/avia/search/result/?${query}${filters ? `#${filters}` : ''}`;
    },
    name: prepareName(SUITE_NAME_PREFIX, 'Выдача'),
    qa: {
        filters: {
            price: 'avia-price-filter-button',
            priceRange: {
                value: 'avia-price-range-value',
                input: 'avia-price-range-input',
            },
        },
    },
};

export interface IOrderUrlParams extends IAviaSearchParams {
    forward?: string;
    backward?: string;
}

export const order = {
    name: prepareName(SUITE_NAME_PREFIX, 'Покупка'),
    url: ({forward, backward, ...options}: IOrderUrlParams): string =>
        `/avia/order/?${[
            getBaseAviaSearchParams(options),
            stringify({forward, backward}),
        ].join('&')}`,
};

export const flightPage = {
    name: prepareName(SUITE_NAME_PREFIX, 'Страница рейса'),
    url: (flight: string, date: string): string => {
        return `/avia/flights/${flight}/?when=${date}`;
    },
};
export default {
    index,
    serp,
    order,
    flightPage,
};
