const mapValues = require('lodash/mapValues');

const getGlobalVariables = require('./webpack/utilities/getGlobalVariables');

const config = {
    testResultsProcessor: 'jest-teamcity-reporter',
    testMatch: [
        '<rootDir>/server/**/__tests__/**/*.{js,jsx,ts,tsx}',
        '<rootDir>/src/**/__tests__/**/*.{js,jsx,ts,tsx}',
        '<rootDir>/src/**/?(*.)(spec|test).{js,jsx,ts,tsx}',
        '<rootDir>/tools/**/?(*.)(spec|test).{js,jsx,ts,tsx}',
    ],
    testPathIgnorePatterns: ['/node_modules/', '/__mocks__/', '/i18n/'],
    testEnvironment: 'jsdom',
    transform: {
        '^.+\\.(js|jsx|ts|tsx)$': 'babel-jest',
        '^.+\\.(css|scss)$': '<rootDir>/jest/cssTransform',
        '^(?!.*\\.(js|jsx|ts|tsx|css|json)$)': '<rootDir>/jest/fileTransform',
    },
    transformIgnorePatterns: ['/node_modules/(?!(@yandex-lego/components)/)'],
    setupFilesAfterEnv: ['<rootDir>/jest/setupTests.js'],
    snapshotSerializers: ['enzyme-to-json/serializer'],
    moduleFileExtensions: ['js', 'jsx', 'json', 'ts', 'tsx'],
    moduleNameMapper: {
        '^server/(.*)$': '<rootDir>server/$1',
        '^sagas/(.*)$': '<rootDir>src/redux/sagas/$1',
        '^types/(.*)$': '<rootDir>src/types/$1',
        '^reducers/(.*)$': '<rootDir>src/redux/reducers/$1',
        '^selectors/(.*)$': '<rootDir>src/redux/selectors/$1',
        '^components/(.*)$': '<rootDir>src/components/$1',
        '^projects/(.*)$': '<rootDir>src/projects/$1',
        '^icons/(.*)$': '<rootDir>src/icons/$1',
        '^containers/(.*)$': '<rootDir>src/containers/$1',
        '^utilities/(.*)$': '<rootDir>src/utilities/$1',
        '^constants/(.*)$': '<rootDir>src/constants/$1',
        '^contexts/(.*)$': '<rootDir>src/contexts/$1',
        '^i18nNew/(.*)$': '<rootDir>src/prerequisites/i18n/keysets/$1',
    },
    globals: mapValues(getGlobalVariables(false), v => JSON.parse(v)),
};

module.exports = config;
