const path = require('path');
const chalk = require('chalk');
const webpack = require('webpack');
const webpackSettingsPath = path.resolve(__dirname, '..', 'webpack');

const clientWebpackConfig = require(`${webpackSettingsPath}/client.webpack.config`);
const serverWebpackConfig = require(`${webpackSettingsPath}/server.webpack.config`);
const {isBuildBundleAnalyzer} = require(`${webpackSettingsPath}/variables`);

const webpackConfigs = [
    clientWebpackConfig,
    ...(isBuildBundleAnalyzer ? [] : [serverWebpackConfig]),
];

const startBuildProd = () =>
    new Promise((resolve, reject) => {
        const webpackBuildCallback = (error, stats) => {
            if (error) {
                console.error(chalk.red(error.stack || error));
                reject();

                if (error.details) {
                    console.error(chalk.red(error.details));
                    reject();
                }
            } else {
                const info = stats.toJson();

                if (stats.hasErrors()) {
                    console.error(chalk.red(info.errors));
                    reject();
                }

                if (stats.hasWarnings()) {
                    console.warn(chalk.yellow(info.warnings));
                }

                resolve();
            }
        };

        webpack(webpackConfigs, webpackBuildCallback);
    });

(async () => {
    await startBuildProd();

    console.log(chalk.green('Production server built success'));
})();
