const cluster = require('cluster');

const startServer = require('../server/start');
const {init} = require('../tools/solomon');

const appInstance = startServer();

const DEFAULT_CLUSTERS_NUMBER = 2;
const FORCE_WORKERS_COUNT = parseInt(process.env.FORCE_WORKERS_COUNT, 10);

// В qloud можно использовать дробные значения для кол-ва ресурсов (0.5 CPU),
const QLOUD_CLUSTER_NUMBER = process.env.QLOUD_CPU_LIMIT
    ? Math.max(parseFloat(process.env.QLOUD_CPU_LIMIT), 1)
    : DEFAULT_CLUSTERS_NUMBER;

const CLUSTERS_NUMBER = FORCE_WORKERS_COUNT || QLOUD_CLUSTER_NUMBER;

if (cluster.isMaster) {
    init();

    for (let i = 0; i < CLUSTERS_NUMBER; i++) {
        cluster.fork();
    }

    cluster.on('exit', (worker, code, signal) => {
        appInstance.utils.log(
            `Worker ${worker.id}, pid: ${worker.process.pid} died, code: ${code}, signal: ${signal}`,
            {
                id: worker.id,
                pid: worker.process.pid,
                code,
                signal,
            },
        );

        if (code === 1) {
            return process.exit();
        }

        if (!worker.suicide) {
            cluster.fork();
        }
    });

    cluster.on('online', worker => {
        appInstance.utils.log(
            `Worker ${worker.id} is online, worker pid ${worker.process.pid}`,
            {
                id: worker.id,
                pid: worker.process.pid,
            },
        );
    });
} else {
    appInstance.run();
}
