/* eslint-disable camelcase */
import {ESubscriptionAuthType} from 'types/subscription/ESubscriptionAuthType';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';
import {ESubscriptionPromoCodeType} from 'types/subscription/ESubscriptionPromoCodeType';
import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';

export interface INotifierSubscribeApiParams {
    authType: ESubscriptionAuthType;
    authValue: string;
    email: string;
    name?: string;
    timezone: string;
    language: string;
    source: ESubscriptionSource;
    travelVerticalName: ESubscriptionVerticalName;
    promoSubscriptionCode: string;
    nationalVersion: string;
}

export interface INotifierSubscribeApiResponse {
    updated: number;
    created: number;
}

export interface IPromoCodeForSubscription {
    type: ESubscriptionPromoCodeType;
    amount: number;
    minTotalCost?: number;
}

export interface INotifierPromoConfig {
    promoCode: IPromoCodeForSubscription | null;
}

export interface INotifierSubscriptionStatus {
    isSubscribed: boolean;
    source: ESubscriptionSource;
    vertical: ESubscriptionVerticalName;
    subscribedAt: string;
    unsubscribedAt: string;
}
