import {IStoreTinyUrlApi} from './types/IStoreTinyUrlApi';
import {IRestoreTinyUrlApi} from './types/IRestoreTinyUrlApi';
import {IAnswerTinyUrlApi} from './types/IAnswerTinyUrlApi';
import {EApiEntry} from 'types/EApiEntry';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from 'server/getContainerConfig';

const tinyUrlDefaultParams = {
    from: 'ticket',
    json: 1,
};

export class TinyUrlApi extends RestApiClient {
    constructor({
        httpClient,
        getApiHost,
        getSrcParams,
        logger,
        requestId,
        sendClickHouseStats,
        rootSpan,
    }: IDependencies) {
        super({
            httpClient,
            baseURL: `${getApiHost(EApiEntry.TINY_URL)}`,
            logger,
            requestId,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.TINY_URL);
    }

    store(params: IStoreTinyUrlApi): Promise<IAnswerTinyUrlApi> {
        return this.get<IAnswerTinyUrlApi>('/', {
            params: {
                method: 'store',
                ...tinyUrlDefaultParams,
                ...params,
            },
        });
    }

    restore(params: IRestoreTinyUrlApi): Promise<IAnswerTinyUrlApi> {
        return this.get<IAnswerTinyUrlApi>('/', {
            params: {
                method: 'retrieve',
                ...tinyUrlDefaultParams,
                ...params,
            },
        });
    }

    protected interceptRequest(request: IRequestConfig): void | Promise<void> {
        if (request.url && request.url.endsWith('/')) {
            request.url = request.url.slice(0, -1);
        }
    }
}
