import 'core-js/stable';
import getContainerConfig from 'server/getContainerConfig';

import commonApiController from './controllers/commonApiController/commonApiController';
import seoExpsController from './controllers/seoExpsController';

const projectApiControllerByType = {
    common: commonApiController,
    seoExps: seoExpsController,
    '-': commonApiController.restoreTinyUrl,
};

function registerContainer(req, res) {
    req.container.register(getContainerConfig(req, res, {isSSR: false}));
}

export default () => (req, resp) => {
    const {params} = req;
    const {project, action, param} = params;
    const projectController = projectApiControllerByType[project];

    let projectAction;

    if (typeof projectController === 'function') {
        projectAction = projectController;
    } else if (projectController) {
        if (param) {
            projectAction =
                projectController[action] && projectController[action][param];
        } else {
            projectAction = projectController[action];
        }

        if (typeof projectAction !== 'function') {
            projectAction = projectController['*'];
        }
    }

    if (typeof projectAction === 'function') {
        registerContainer(req, resp);

        projectAction(req, resp);
    } else {
        resp.status(404).send();
    }
};
