const {csp} = require('@yandex-data-ui/core');

const getVersion = require('../../tools/version');
const commonCspPresets = require('./csp/presets/common');
const testingCspPresets = require('./csp/presets/testing');
const productionCspPresets = require('./csp/presets/production');

const version = getVersion();

const CSP_YANDEX = 'yandex.ru';
const CSP_YANDEX_DOMAINS = '*.yandex.ru:*';
const CSP_YANDEX_COM_DOMAINS = '*.yandex.com';
const CSP_IFRAME_TOLOKA = 'iframe-toloka.com';
const CSP_SANDBOX_IFRAME_TOLOKA = 'sandbox.iframe-toloka.com';
const CSP_YAPIC = 'yapic.yandex.ru';
const CSP_IMG_YANDEX_RU = 'img.yandex.ru';
const CSP_YMAPS_STATIC = 'static-maps.yandex.ru';
const CSP_YMAPS_API = 'api-maps.yandex.ru';
const CSP_CLCK = 'clck.yandex.ru';
const CSP_AEROFLOT = 'pay.test.aeroflot.ru';
const CSP_RBSUAT = 'web.rbsuat.com';
const CSP_I_TRAVEL = 'i.travelapi.com';
const CSP_DELFINCHIK = 'http://ppt.delfinchik.net';
const CSP_YANDEX_COUNTERS = 'https://yandex.ru/clck/click';
const CSP_TEST_NET_URL = 'https://travel-test.yandex.net';
const CSP_NET_URL = 'https://travel.yandex.net';
const CSP_3DS_TEST_URL = 'https://3ds.travel-test.yandex.net';
const CSP_3DS_PRESTABLE_URL = 'https://3ds.travel-prestable.yandex.net';
const CSP_3DS_URL = 'https://3ds.travel.yandex.net';
const CSP_YASTAT = 'yastat.net';
const CSP_YANDEX_CHAT_NET = 'chat.s3.yandex.net';
const CSP_MAIL = 'https://mail.yandex.ru';
const CSP_TRAVELLINE_1 = 'www.qatl.ru';
const CSP_TRAVELLINE_2 = 'www.travelline.ru';
const CSP_BNOVO = 'https://reservationsteps.ru/files/';
const CSP_BUG_PRESET = [
    'https://yandex.ru/ecoo/testids/suggest',
    'https://yandex.ru/ecoo/sign',
    'https://yandex.ru/ecoo/clean',
    'https://yandex.ru/ecoo/check',
];
const CSP_IZI_TRAVEL = 'http://media.izi.travel';
const CSP_YANDEX_MARKET = 'aflt.market.yandex.ru';
const CSP_YSA_STATIC = 'https://ysa-static.passport.yandex.ru/static/'; // Используется в виджете Яндекс.Маркета

const CLICKHOUSE_TABLE_CONFIG = {
    service: 'string',
    responseStatus: 'number',
    requestId: 'string',
    requestTime: 'number',
    requestMethod: 'string',
    requestUrl: 'string',
    timestamp: 'number',
};

module.exports = {
    version,
    csp: {
        /*
         * Когда баг с prefetch-src пофиксится, переместить CSP_YASTAT в prefetch-src
         *
         * @see https://bugs.chromium.org/p/chromium/issues/detail?id=801561
         */
        'default-src': [csp.BLOB, CSP_YASTAT],
        'script-src': [
            CSP_YANDEX,
            CSP_YASTAT,
            CSP_YANDEX_MARKET,
            CSP_YANDEX_CHAT_NET,
        ],
        'style-src': [CSP_YASTAT],
        'img-src': [
            csp.BLOB,
            CSP_CLCK,
            CSP_YAPIC,
            CSP_IMG_YANDEX_RU,
            CSP_I_TRAVEL,
            CSP_YANDEX_COUNTERS,
            CSP_YASTAT,
            CSP_DELFINCHIK,
            CSP_TRAVELLINE_1,
            CSP_TRAVELLINE_2,
            CSP_BNOVO,
            CSP_YMAPS_STATIC,
            CSP_IZI_TRAVEL,
            CSP_YSA_STATIC,
        ],
        'media-src': [csp.BLOB],
        'connect-src': [
            CSP_YANDEX_COUNTERS,
            CSP_YASTAT,
            CSP_MAIL,
            CSP_YMAPS_API,
            CSP_YANDEX_MARKET,
            ...CSP_BUG_PRESET,
        ],
        'frame-src': [
            csp.BLOB,
            CSP_YANDEX,
            CSP_AEROFLOT,
            CSP_RBSUAT,
            CSP_3DS_URL,
            CSP_3DS_PRESTABLE_URL,
            CSP_3DS_TEST_URL,
            CSP_TEST_NET_URL,
            CSP_NET_URL,
            CSP_YASTAT,
        ],
        'frame-ancestors': [
            CSP_3DS_URL,
            CSP_3DS_PRESTABLE_URL,
            CSP_3DS_TEST_URL,
            CSP_YANDEX,
            CSP_YANDEX_DOMAINS,
            CSP_YANDEX_COM_DOMAINS,
            CSP_IFRAME_TOLOKA,
            CSP_SANDBOX_IFRAME_TOLOKA,
        ],
        'font-src': [CSP_YASTAT],
    },
    cspPresets: [
        ...commonCspPresets,
        ...testingCspPresets,
        ...productionCspPresets,
    ],
    authPolicy: 'optional',
    passport: {
        blackbox: {
            attributes: {login: '1008', lang: '34', plus: '1015'},
            fields: {
                yandexoid: 'subscription.login.669',
                betatest: 'subscription.login.668',
            },
        },
    },
    static: {
        provider: 'https://yastat.net/s3/travel/',
        staticPath: `static/client/${version}/`,
        freezePath: 'static/_/',
    },
    uaasExperiments: {
        aviaSearchSortDefaultByPriceWithoutByInterest:
            'AVIA_SEARCH_sort:default_by_price_without_by_interest',
        trainsHideAdsSerp: 'TRAINS_hide_ads_serp:test',
        hotelsTopSnippet: 'HOTELS_snippet:enabled',
        hotelsSkipSnippetForm: 'HOTELS_skip_snippet_form:enabled',
        passToMetricHotelsSearchPageSearchtime:
            'HOTELS_pass_searchtime:enabled',
        trainsNewTrustForm: 'TRAINS_new_form:enabled',
        busesOrchestrator: 'BUSES_orchestrator:enabled',
        hotelsPreviousSearches: 'HOTELS_previous_searches:enabled',
        aviaAeroflotPlus: 'avia_aeroflot_plus:enabled',
        hotelsNewTrustForm: 'HOTELS_new_form:enabled',
        trainsNewPlacesPassengers: 'Trains_new_places_passengers:enabled',
        trainsNewPlacesTypeWagons: 'Trains_new_places_type_wagons:enabled',
        trainsNewPlacesTabWagons: 'Trains_new_places_tab_wagons:enabled',
        trainsDesktopPlacesPassengers:
            'TRAINS_desktop_places_passengers:enabled',
        trainsDesktopPlacesTypeWagons:
            'TRAINS_desktop_places_type_wagons:enabled',
        trainsDesktopPlacesTabWagons:
            'TRAINS_desktop_places_tab_wagons:enabled',
        trainsOnlyDirect: 'TRAINS_only_direct:enabled',
        trainsOfferPassengerPlaces: 'TRAINS_offer_passenger_places:enabled',
        trainsScrollToConfirmStep: 'TRAINS_scroll_to_confirm_step:enabled',
        trainsScrollToPassengersStep:
            'TRAINS_scroll_to_passengers_step:enabled',
        trainsDisableCoachTypeTabs: 'TRAINS_disable_coach_type_tabs:enabled',
        aviaSearchToCountryPage: 'avia_search_to_country_page:enabled',
        aviaSearchToAnywherePage: 'avia_search_to_anywhere_page:enabled',
        subscriptionWithoutPromoCode:
            'MARKETING_promo_for_subscription:disabled',
        subscriptionWithPromoCode: 'MARKETING_promo_for_subscription:enabled',
        upperSubscriptionForm: 'MARKETING_morda_upper_subscription:enabled',
        aviaMonthPricesExp: 'AVIA_monthPricesExp:enabled',
        roomsMatching: 'HOTELS_rooms_matching:enabled',
        newDatePickerEnabled: 'TRAVEL_new_datepicker:enabled',
        priceAfterPlusWithdrawTop: 'MARKETING_price_after_plus_withdraw:top',
        priceAfterPlusWithdrawBottom:
            'MARKETING_price_after_plus_withdraw:bottom',
        hotelsPercentDiscount: 'HOTELS_percent:enabled',
        trainsSearchHotelsCrossSaleEnabled:
            'KOMOD_trains_search_hotels_cross_sale:enabled',
        hotelsNewMapSnippet: 'HOTELS_mapsnippet:enabled',
        aviaSearchLowerCrossSaleEnabled:
            'KOMOD_avia_search_lower_cross_sale:enabled',
        hotelsInfiniteScroll: 'HOTELS_infinite:enabled',
        tripPageActivitiesEnabled: 'KOMOD_trip_page_activities:enabled',
        aviaCleanSerpEnabled: 'KOMOD_avia_clean_serp:enabled',
        trainsCleanSerpEnabled: 'KOMOD_trains_clean_serp:enabled',
        hotelsCleanSerpEnabled: 'KOMOD_hotels_clean_serp:enabled',
        aviaDesktopTariffPopup: 'AVIA_desktop_tariff_popup:enabled',
        aviaDesktopTariffDropdownWithPrices:
            'AVIA_desktop_tariff_dropdown_with_prices:enabled',
        hotelsHeaderRedesign: 'HOTELS_header:enabled',
    },
    experiments: {
        // Common

        // Trains
        skipSalesCheck: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },
        trainsAllowInternationalRoutes: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },

        // Avia
        isAviaPortal: {
            type: Boolean,
            defaultValue: false,
            denied: false,
        },

        // Hotels
        hotelsBookPage: {
            type: Boolean,
            defaultValue: false,
            denied: true,
        },
    },
    features: {
        enableFeaturesPage: false,
    },
    s3storage: {
        accountBucket: 'account-order-search',
    },
    cookieSession: {
        secret: 'COOKIE_SESSION_SECRET',
    },
    telemetryChHost: 'man-iajiyg2g16081u8t.db.yandex.net',
    telemetryChPort: 8443,
    telemetryChDatabase: 'api_logs',
    telemetryChAuth: process.env.TELEMETRY_CLICKHOUSE_CREDENTIALS,
    telemetryChTables: {
        env_testing: CLICKHOUSE_TABLE_CONFIG,
        env_production: CLICKHOUSE_TABLE_CONFIG,
    },
    telemetryChBatchSize: 500,
    avia: {
        // названия партнеров добавляются строго через запятую без пробелов
        notInstantPartners: process.env.AVIA_NOT_INSTANT_PARTNERS,
    },
    fileLogging: null,
    nationalSettings: {
        default: {
            nationalCurrency: 'RUR',
            allowedCurrencies: ['RUR'],
        },
        ru: {
            nationalCurrency: 'RUR',
            allowedCurrencies: ['RUR', 'USD', 'EUR', 'KZT'],
        },
    },
    domainToNationalVersion: {
        ru: 'ru',
        ua: 'ua',
        'com.tr': 'tr',
        com: 'com',
        kz: 'kz',
    },
    webvisor: {
        inclusionPercent: {
            projects: {
                trains: 0.05,
            },
            defaultPercent: 1,
        },
    },
    disableIncompatible: true,
};
