const {csp} = require('@yandex-data-ui/core');

module.exports = (env = 'production') => {
    const isProduction = env === 'production';

    const trustHosts = {
        production: `trust.yandex.${csp.TLD}`,
        testing: `trust-test.yandex.${csp.TLD}`,
        local: `trust.local.yandex.${csp.TLD}:3000`,
    };

    return {
        [csp.CONNECT]: isProduction
            ? [trustHosts.production]
            : [trustHosts.testing],
        [csp.FRAME]: isProduction
            ? [trustHosts.production]
            : [trustHosts.testing, trustHosts.local],
    };
};
