// @ts-check

/**
 * @param {import('@yandex-data-ui/core/lib/types').Request} req
 * @param {import('@yandex-data-ui/core/lib/types').Response} res
 */
module.exports = function threeDSIFrameController(req, res) {
    let iframeUrl;

    try {
        iframeUrl = new URL(decodeURIComponent(req.query.url));
    } catch (e) {
        res.sendStatus(400);

        return;
    }

    res.removeHeader('Content-Security-Policy');
    res.send(`
        <style>
            body {margin: 0;}
            iframe {width: 100%; height: 100%; border: none;}
        </style>
        <iframe src="${iframeUrl}"></iframe>
        <script>
            const iframe = document.getElementsByTagName('iframe')[0];

            window.addEventListener('message', function(event) {
                const targetOrigin = '*';

                const isEventFromIframe = iframe && iframe.contentWindow === event.source;

                if (isEventFromIframe) {
                    window.parent.postMessage(event.data, targetOrigin);

                    return;
                }

                if (iframe) {
                    iframe.contentWindow.postMessage(event.data, targetOrigin);
                }
            });
        </script>
    `);
};
