import {HTTP_SERVER_ERROR_CODE} from 'server/constants/httpCodes';

import {Response} from '@yandex-data-ui/core/lib/types';

type TErrorResponsePreparer = (apiError: any) => IBaseErrorResponse;

export interface IBaseErrorResponse {
    statusCode: number;
    error?: string | {code: string} | null;
    data?: any;
}

export class ApiBaseController {
    sendSuccessResponse =
        <T>(res: Response) =>
        (data: T) => {
            res.json({
                data,
                error: null,
            });
        };

    sendErrorResponse =
        (
            res: Response,
            prepareErrorResponse: TErrorResponsePreparer = this
                .defaultErrorPreparer,
        ) =>
        (apiError: any = {}) => {
            const {statusCode, error, data} = prepareErrorResponse(apiError);

            res.status(statusCode).send({
                error: error || null,
                data: data || null,
            });
        };

    protected defaultErrorPreparer = (apiError: any): IBaseErrorResponse => {
        const statusCode = apiError?.response?.status || HTTP_SERVER_ERROR_CODE;
        return {
            statusCode,
            error: 'Server error',
        };
    };
}
