import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {IDependencies} from 'server/getContainerConfig';
import {handleError} from 'server/controllers/handleError';
import {handleResponse} from 'server/controllers/handleResponse';
import {CurrenciesService} from 'server/services/CurrenciesService/CurrenciesService';

class CurrenciesController {
    private currenciesService: CurrenciesService;

    constructor({currenciesService}: IDependencies) {
        this.currenciesService = currenciesService;
    }

    @logAction
    getCurrencies(req: Request, res: Response): void {
        this.currenciesService
            .getCurrencyInfoByUserGeoLocation()
            .then(handleResponse(res), handleError(res));
    }
}

export default makeProxyInvoker(CurrenciesController);
