import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';
import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {IDependencies} from 'server/getContainerConfig';
import {handleError} from 'server/controllers/handleError';
import {handleResponse} from 'server/controllers/handleResponse';
import {ExperimentsService} from 'server/services/ExperimentsService/ExperimentsService';

class ExperimentsController {
    private experimentsService: ExperimentsService;

    constructor({experimentsService}: IDependencies) {
        this.experimentsService = experimentsService;
    }

    @logAction
    @requestMethod('GET')
    experiments(req: Request, res: Response): void {
        this.experimentsService
            .getExperiments()
            .then(handleResponse(res), handleError(res));
    }
}

export default makeProxyInvoker(ExperimentsController);
