import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {IDependencies} from 'server/getContainerConfig';
import {handleError} from 'server/controllers/handleError';
import {handleResponse} from 'server/controllers/handleResponse';
import {TinyUrlService} from 'server/services/TinyUrlService/TinyUrlService';

class TinyUrlController {
    private tinyUrlService: TinyUrlService;

    constructor({tinyUrlService}: IDependencies) {
        this.tinyUrlService = tinyUrlService;
    }

    @logAction
    store(req: Request, res: Response): void {
        const params = {
            requestHostname: req.hostname,
            url: req.query.url,
        };

        this.tinyUrlService
            .store(params)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    restore(req: Request, res: Response): void {
        this.tinyUrlService.restore({token: req.params.token}).then(
            url => res.redirect(url),
            () => res.sendStatus(404),
        );
    }
}

export default makeProxyInvoker(TinyUrlController);
