import notifierController from 'server/controllers/commonApiController/NotifierController';
import countriesController from 'server/controllers/commonApiController/CountriesController';
import currenciesController from 'server/controllers/commonApiController/CurrenciesController';
import tinyUrlController from 'server/controllers/commonApiController/TinyUrlController';
import solomonApiController from 'server/controllers/solomonController/SolomonApiController';
import geobaseApiController from 'server/controllers/commonApiController/GeobaseApiController';
import shareImageController from 'server/controllers/commonApiController/ShareImageController';
import experimentsController from 'server/controllers/commonApiController/ExperimentsController';

export default {
    countries: countriesController.getCountries,
    currencies: currenciesController.getCurrencies,
    storeTinyUrl: tinyUrlController.store,
    restoreTinyUrl: tinyUrlController.restore,
    solomon: solomonApiController.push,
    shareImages: shareImageController.get,
    shareImagesPing: shareImageController.ping,
    notifier: {
        subscribe: notifierController.subscribe,
        unsubscribe: notifierController.unsubscribe,
        getStatus: notifierController.getStatus,
        getPromoConfig: notifierController.getPromoConfig,
    },
    geobase: {
        getUserGeoLocation: geobaseApiController.getUserGeoLocation,
    },
    experiments: experimentsController.experiments,
};
