import {
    HTTP_BAD_REQUEST_CODE,
    HTTP_INTERNAL_ERROR_CODE,
} from 'server/constants/httpCodes';

import {Response} from '@yandex-data-ui/core/lib/types';

import {isBadRequestError} from 'server/utilities/HttpClient/isBadRequestError';

export function handleError(res: Response) {
    return (ex: any) => {
        if (ex.response) {
            res.status(ex.response.status).send(
                typeof ex.response.data === 'string'
                    ? encodeURIComponent(ex.response.data)
                    : ex.response.data,
            );
        } else {
            if (__DEV__) {
                console.error(ex);
            }

            let status = HTTP_INTERNAL_ERROR_CODE;

            if (isBadRequestError(ex)) {
                status = HTTP_BAD_REQUEST_CODE;
            }

            res.status(status).send();
        }
    };
}
