import {Response} from '@yandex-data-ui/core/lib/types';

export function handlePdfFileStream(
    res: Response,
    options: {fileName: string},
) {
    return (fileStream: NodeJS.ReadableStream): void => {
        res.set(
            'Content-Disposition',
            `attachment; filename=${options.fileName}.pdf`,
        );

        res.type('application/pdf');

        fileStream.pipe(res);
    };
}
