import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import makeProxyInvoker from 'server/utilities/makeProxyInvoker';
import requestMethod from 'server/utilities/decorators/requestMethod';
import requiredParams from 'server/utilities/decorators/requiredParams';

import {IDependencies} from 'server/getContainerConfig';
import {handleError} from 'server/controllers/handleError';
import {handleResponse} from 'server/controllers/handleResponse';
import {SeoExpsService} from 'server/services/SeoExpsService/SeoExpsService';

class SeoExpsController {
    private seoExpsService: SeoExpsService;

    constructor({seoExpsService}: IDependencies) {
        this.seoExpsService = seoExpsService;
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['service', 'collection', 'pageId', 'platform'])
    getModifications(req: Request, res: Response): void {
        this.seoExpsService
            .getModifications(req.query)
            .then(handleResponse(res), handleError(res));
    }
}

export default makeProxyInvoker(SeoExpsController);
