/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 * @typedef {import('@yandex-data-ui/core/lib/types').Response} Response
 */

const {getData} = require('../../../tools/solomon');
const getPushClientSensors = require('./pushClient');

/**
 * @param {Request} req
 * @param {Response} res
 * @returns {void}
 */
module.exports = async function (req, res) {
    const {service} = req.params;

    try {
        const data = await getDataForService(service);

        res.setHeader('Content-Type', 'application/json');
        res.send(data);
    } catch (e) {
        res.status(400).send(e && e.message);
        req.utils.logError(`Не удалось отдать данные в соломон`, e);
    }
};

function getDataForService(service) {
    if (service === 'pushClient') {
        return getPushClientSensors();
    }

    return getData();
}
