import {TLogPlainObject} from '../types/TLogPlainObject';

import {BaseFileLogger} from './BaseFileLogger';

export class BaseJSONLog extends BaseFileLogger {
    protected format<T>(msg: T): string {
        const data = this.parseValues(msg);

        return JSON.stringify(data);
    }

    private parseValues(data: any): [TLogPlainObject] | TLogPlainObject | null {
        const dataType = typeof data;

        if (Array.isArray(data)) {
            return data.map(item => this.parseValues(item));
        } else if (dataType === 'object' && data !== null) {
            return Object.keys(data).reduce((newData, k) => {
                newData[k] = this.parseValues(data[k]);

                return newData;
            }, {} as TLogPlainObject);
        } else if (
            dataType === 'boolean' ||
            dataType === 'string' ||
            dataType === 'number'
        ) {
            return data;
        }

        return null;
    }
}
