/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 * @typedef {import('@yandex-data-ui/core/lib/types').Response} Response
 * @typedef {import('@yandex-data-ui/core/lib/types').NextFunction} NextFunction
 */

const {setExperimentsToRequest} = require('../providers/experiments');

/**
 * Вызывает функцию добавления в запрос данных из uaas.
 *
 * @param {Request} req
 * @param {Response} _res
 * @param {NextFunction} next
 * @returns {Promise<void>}
 */
async function experimentsMiddleware(req, _res, next) {
    await setExperimentsToRequest(req);
    next();
}

module.exports = experimentsMiddleware;
