/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 * @typedef {import('@yandex-data-ui/core/lib/types').Response} Response
 * @typedef {import('@yandex-data-ui/core/lib/types').NextFunction} NextFunction
 */

const platforms = require('../constants/platforms');

const {fromYandex} = require('../utilities/fromYandex');

const fakePlatformCookieAndroid = 'fake-android';
const fakePlatformCookieIos = 'fake-ios';

/**
 * @param {Request} req
 * @returns {void}
 */
function setFakePlatform(req) {
    if (fromYandex(req)) {
        if (Number(req.cookies[fakePlatformCookieAndroid])) {
            req.platform = platforms.ANDROID;
            req.isFakeApp = true;
        }

        if (Number(req.cookies[fakePlatformCookieIos])) {
            req.platform = platforms.IOS;
            req.isFakeApp = true;
        }
    }
}

/**
 * @param {Request} req
 * @param {Response} _res
 * @param {NextFunction} next
 * @returns {void}
 */
function fakePlatformMiddleware(req, _res, next) {
    try {
        setFakePlatform(req);
    } catch (e) {
        req.utils.logError('fakePlatformMiddleware', e);
    }

    next();
}

module.exports = fakePlatformMiddleware;
