/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 * @typedef {import('@yandex-data-ui/core/lib/types').Response} Response
 * @typedef {import('@yandex-data-ui/core/lib/types').NextFunction} NextFunction
 */

const platforms = require('../constants/platforms');

const {fromYandex} = require('../utilities/fromYandex');

/**
 * @param {Request} req
 * @param {Response} res
 * @returns {void}
 */
function setMobileVersion(req) {
    if (req.platform === platforms.WEB) {
        return;
    }

    if (req.isFakeApp && fromYandex(req)) {
        req.uatraits.isMobile = true;
        req.uatraits.isBrowser = false;
    }
}

/**
 * @param {Request} req
 * @param {Response} res
 * @param {NextFunction} next
 * @returns {void}
 */
function forceMobileVersionMiddleware(req, res, next) {
    try {
        setMobileVersion(req);
    } catch (e) {
        req.utils.logError('forceMobileVersionMiddleware', e);
    }

    next();
}

module.exports = forceMobileVersionMiddleware;
