/**
 * Не пускаем IE в сервис
 * https://st.yandex-team.ru/TRAVELFRONT-4711
 */

const incompatibleUrl = require('../constants/incompatibleUrl');

const isIE = require('../utilities/isIE');

module.exports = function (req, res, next) {
    const isBrowserIncompatible = isIE(req.uatraits);

    if (isBrowserIncompatible) {
        res.redirect(incompatibleUrl, 302);

        req.utils.logWarn('Redirect to incompatible page');

        return;
    }

    next();
};
