import platforms from '../constants/platforms';

import {
    Request,
    Response,
    NextFunction,
} from '@yandex-data-ui/core/build/types';

const mobilePlatforms = new Set([
    platforms.IOS,
    platforms.ANDROID,
    platforms.WP,
]);

const defaultPlatform = platforms.WEB;

const platformHeaderName = 'x-avia-platform';
const platformCookieName = 'avia-platform';

function setPlatform(req: Request, res: Response): void {
    const headerPlatform = req.headers[platformHeaderName];
    const cookiesPlatform = req.cookies[platformCookieName];

    let platform = headerPlatform || cookiesPlatform;

    if (Array.isArray(platform)) {
        platform = platform[0];
    }

    if (!mobilePlatforms.has(platform)) {
        req.platform = defaultPlatform;

        return;
    }

    if (platform !== cookiesPlatform) {
        res.cookie(platformCookieName, platform, {httpOnly: true});
    }

    req.platform = platform;
}

export default function platformMiddleware(
    req: Request,
    res: Response,
    next: NextFunction,
): void {
    try {
        setPlatform(req, res);
    } catch (e) {
        req.utils.logError('platformMiddleware', e);
    }

    next();
}
