import {TUaasExperiments} from '@yandex-data-ui/core/lib/types';

export interface IExperiment {
    HANDLER: THandler;
    CONTEXT: {
        MAIN: {
            source: TRawExperiments;
        };
    };
}

export type THandler = 'TRAVEL';

/**
 * Строка из конфига configExperimentKey: 'experimentKey:experimentValue'
 * Будет объект {[experimentKey]: experimentValue} extends IBackFLags
 * Куда попал пользователь
 */
export type TRawExperiments = IBackFLags & Record<string, string>;

/* eslint-disable camelcase */
interface IBackFLags {
    back_flags?: string;
}

export interface IInitialUserSplitData {
    rawExperiments: TRawExperiments;
    configVersion: string;
    testIds: string;
    encryptedExperiments: string;
    boxes: string;
}

export interface IUserSplit {
    configVersion: string;
    experiments: TExperiments;
    testIds: string;
    rawExperiments: TRawExperiments;
    encryptedExperiments: string;
    boxes: string;
    backFlags?: string;
}

/**
 * Строка из конфига configExperimentKey: 'experimentKey:experimentValue'
 * Будет объект {[configExperimentKey]: boolean}
 * Куда попал пользователь
 */
export type TExperiments = Partial<Record<keyof TUaasExperiments, boolean>>;

export interface IUaasRequestHeaders {
    'X-Forwarded-For-Y'?: string;
    'User-Agent'?: string;
    Host?: string;
    'X-Yandex-UAAS': string;
    cookie?: string;
}
