/**
 * @typedef {import('../types').IUaasRequestHeaders} IUaasRequestHeaders
 * @typedef {import('axios').AxiosResponse} AxiosResponse
 */

const axios = require('axios');

/**
 *
 * @param {string} uri
 * @param {IUaasRequestHeaders} headers
 * @returns {Promise<AxiosResponse>}
 */
function fetchUaas(uri, headers) {
    return axios.get(uri, {headers});
}

module.exports = {
    fetchUaas,
};
