/**
 * @typedef {import('../types').THandler} THandler
 * @typedef {import('../types').TRawExperiments} TRawExperiments
 */

const {get} = require('lodash');

const {decodeUaasRawExperiment} = require('./decodeUaasRawExperiment');
const {mergeUaasBackFlags} = require('./mergeUaasBackFlags');

/**
 *
 * @param {String} rawExperimentsString
 * @param {THandler} handler
 * @returns {TRawExperiments}
 */
function getUaasRawExperiments(rawExperimentsString = '', handler) {
    return rawExperimentsString
        .split(',')
        .reduce((parsedExperiments, rawExperiment) => {
            if (!rawExperiment) {
                return parsedExperiments;
            }

            const experimentGroups = decodeUaasRawExperiment(rawExperiment);

            experimentGroups.forEach(experiment => {
                // Теоретически возможна ситуация, когда в чужих экспериментах совпадет ключ эксперимента с нами
                if (experiment.HANDLER !== handler) {
                    return;
                }

                const experimentData = get(experiment, [
                    'CONTEXT',
                    'MAIN',
                    'source',
                ]);

                if (!experimentData) {
                    return;
                }

                const {back_flags: backFlags, ...rest} = experimentData;

                Object.assign(parsedExperiments, rest);

                if (backFlags) {
                    parsedExperiments.back_flags = mergeUaasBackFlags(
                        parsedExperiments.back_flags,
                        backFlags,
                    );
                }
            });

            return parsedExperiments;
        }, {});
}

module.exports = {
    getUaasRawExperiments,
};
