/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 * @typedef {import('../types').IUaasRequestHeaders} IUaasRequestHeaders
 */

/**
 * Собирает нужные для uaas заголовки запроса
 *
 * @param {Request} req
 * @returns {IUaasRequestHeaders}
 */
function getUaasRequestHeaders(req) {
    const cookie = req.get('cookie');

    return {
        'X-Forwarded-For-Y': req.headers['x-real-ip'],
        'User-Agent': req.headers['user-agent'],
        Host: req.headers['host'],
        'X-Yandex-UAAS': req.utils.config.uaas.env,
        ...(cookie && {cookie}),
    };
}

module.exports = {
    getUaasRequestHeaders,
};
