/**
 * @typedef {import('query-string').ParsedQuery} ParsedQuery
 */
const {TEST_ID_FIELD} = require('./uaasConstants');

/**
 * Достает test-id, в параметрах запроса он обычно лежит когда функция вызывалась в мидлвари,
 * а в реферере - когда пришли по ajax
 *
 * @param {ParsedQuery} query
 * @param {string|undefined} referrer
 * @returns {string|undefined}
 */
function getUaasTestId(query, referrer) {
    if (query[TEST_ID_FIELD]) {
        return query[TEST_ID_FIELD];
    }

    if (referrer) {
        const ref = new URL(referrer);
        return ref.searchParams.get(TEST_ID_FIELD);
    }

    return undefined;
}

module.exports = {
    getUaasTestId,
};
