/**
 * @typedef {import('@yandex-data-ui/core/lib/types').CoreConfig} CoreConfig
 */

/** @type {CoreConfig} */
const config = require('../../../../.config');
const {TEST_ID_FIELD} = require('./uaasConstants');

/**
 *
 * @param {string|undefined} testId
 * @returns {string}
 */
function getUaasUri(testId) {
    const uri = new URL(config.uaas.uri);

    if (testId) {
        uri.searchParams.set(TEST_ID_FIELD, testId);
    }

    return uri.toString();
}

module.exports = {
    getUaasUri,
};
