/**
 * @typedef {import('@yandex-data-ui/core/lib/types').CoreConfig} CoreConfig
 * @typedef {import('../types').IUaasRequestHeaders} IUaasRequestHeaders
 * @typedef {import('../types').IUserSplit} IUserSplit
 */

const {getInitialUserSplitData} = require('./getInitialUserSplitData');
const {mapExperimentsConfig} = require('./mapExperimentsConfig');
/** @type {CoreConfig} */
const config = require('../../../../.config');

/**
 *
 * @param {string} uri
 * @param {IUaasRequestHeaders} requestHeaders
 * @returns {Promise<IUserSplit>}
 */
async function getUserSplit(uri, requestHeaders) {
    const initialUsrSplitData = await getInitialUserSplitData(
        uri,
        requestHeaders,
    );

    const {
        rawExperiments,
        configVersion,
        testIds,
        encryptedExperiments,
        boxes,
    } = initialUsrSplitData;

    const experiments = mapExperimentsConfig(
        config.uaasExperiments,
        rawExperiments,
    );

    return {
        configVersion,
        experiments,
        rawExperiments,
        testIds,
        encryptedExperiments,
        boxes,
        backFlags: rawExperiments.back_flags,
    };
}

module.exports = {
    getUserSplit,
};
