import {Request} from '@yandex-data-ui/core/lib/types';
import {IUserSplit} from '../types';

import {unknownToErrorOrUndefined} from 'utilities/error';

import {getUserSplitByRequest} from './getUserSplitByRequest';
import {mergeUserSplitWithCookie} from './mergeUserSplitWithCookie';
import getUserNetworkTraits from '../../geoBase/getUserNetworkTraits';
import {reduceUsers} from '../../userInfo';

/**
 * ВОзвращает IUserSplit, предполагается использовать в отделенных от запроса контейнерах,
 * передавая ее через DI в getContainerConfig
 */
export async function getUserSplitStandalone(
    req: Request,
): Promise<IUserSplit> {
    try {
        const blackbox = req.blackbox;

        const userInfo = blackbox ? reduceUsers(req.blackbox) : {};

        let [traits, userSplit] = await Promise.all([
            getUserNetworkTraits(req),
            getUserSplitByRequest(req),
        ]);

        if (!traits) {
            traits = {};
        }

        if (userInfo.isStaff || traits.is_yandex_net) {
            userSplit = mergeUserSplitWithCookie(userSplit, req.cookies);
        }

        return userSplit;
    } catch (e) {
        req.utils.logError(
            'Не удалось получить userSplit',
            unknownToErrorOrUndefined(e),
        );

        return {} as IUserSplit;
    }
}
