/**
 * @typedef {import('@yandex-data-ui/core/lib/types').TUaasExperiments} TUaasExperiments
 * @typedef {import('../types').TRawExperiments} TRawExperiments
 * @typedef {import('../types').TExperiments} TExperiments
 */

const {parseExperimentString} = require('./parseExperimentString');

/**
 *
 * @param {TUaasExperiments} experimentConfig
 * @param {TRawExperiments} rawExperiments
 * @returns {TExperiments}
 */
function mapExperimentsConfig(experimentConfig, rawExperiments) {
    return Object.keys(experimentConfig).reduce(
        (experiments, experimentsConfigKey) => {
            // костыль, который нужно заменить на переопределение конфига где-нибудь в рендере
            if (typeof experimentConfig[experimentsConfigKey] === 'boolean') {
                experiments[experimentsConfigKey] =
                    experimentConfig[experimentsConfigKey];

                return experiments;
            }

            const {experimentKey, experimentValue} = parseExperimentString(
                experimentConfig[experimentsConfigKey],
            );

            if (
                rawExperiments[experimentKey] &&
                rawExperiments[experimentKey] === experimentValue
            ) {
                experiments[experimentsConfigKey] = true;
            }

            return experiments;
        },
        {},
    );
}

module.exports = {
    mapExperimentsConfig,
};
