/**
 * @typedef {import('../types').IInitialUserSplitData} IInitialUserSplitData
 * @typedef {import('@yandex-data-ui/core/lib/types').CoreConfig} CoreConfig
 */

const {
    EXPFLAGS,
    EXP_CONFIG_VERSION,
    EXPBOXES,
    EXPBOXES_CRYPTED,
} = require('./uaasConstants');
const {getUaasRawExperiments} = require('./getUaasRawExperiments');
const {parseUaasTestIds} = require('./parseUaasTestIds');
/** @type {CoreConfig} */
const config = require('../../../../.config');

/**
 * Формирует из заголовка ответа uaas удобный для обработки объект
 *
 * @param {Object} headers
 * @returns {IInitialUserSplitData}
 */
function parseUaasResponseHeaders(headers) {
    const rawExperiments = getUaasRawExperiments(
        headers[EXPFLAGS],
        config.uaas.handler,
    );

    return {
        rawExperiments,
        configVersion: headers[EXP_CONFIG_VERSION],
        testIds: parseUaasTestIds(headers[EXPBOXES]),
        encryptedExperiments: headers[EXPBOXES_CRYPTED],
        boxes: headers[EXPBOXES],
    };
}

module.exports = {
    parseUaasResponseHeaders,
};
