const {QLOUD_HTTP_SERVICES_TIMEOUT} = require('../../constants/common');

const isStandalone = Boolean(process.env.USE_LOCAL_GEOBASE);

let httpGeobase;
let localGeobase;

const getHttpGeobase = () => {
    if (!httpGeobase) {
        // eslint-disable-next-line global-require
        const HttpGeobase = require('http-geobase').default;

        httpGeobase = new HttpGeobase('http://geobase-test.qloud.yandex.ru', {
            timeout: QLOUD_HTTP_SERVICES_TIMEOUT,
        });
    }

    return httpGeobase;
};

const getLocalGeobase = () => {
    if (!localGeobase) {
        // eslint-disable-next-line global-require
        const LocalGeobase = require('@yandex-int/yandex-geobase').default;

        localGeobase = LocalGeobase.v6({
            geobaseData: '/var/cache/geobase/geodata6.bin',
        });
    }

    return localGeobase;
};

/**
 * ITraits в локальной геобазе отличается от ITraits в http геобазе
 * @param { Object } localTraits https://a.yandex-team.ru/arcadia/frontend/packages/yandex-geobase/src/geobase6.ts?rev=r8048684#L109
 * @returns { ITraits } https://wiki.yandex-team.ru/http-geobase/api-v1/#get/v1/gettraitsbyip
 */
const convertLocalTraitsToHttpTraits = localTraits => {
    return {
        is_yandex_net: localTraits.yandex_net,
        is_yandex_staff: localTraits.yandex_staff,
        region_id: localTraits.region_id,
        isp_name: localTraits.isp_name,
        org_name: localTraits.org_name,
        asn_list: localTraits.asn_list,
    };
};

module.exports = async req =>
    isStandalone
        ? convertLocalTraitsToHttpTraits(
              getLocalGeobase().getIpTraits(req.headers['x-real-ip']),
          )
        : getHttpGeobase().traitsByIp(req.headers['x-real-ip']);
