import {Action} from 'typesafe-actions';

import {Request} from '@yandex-data-ui/core/lib/types';

import {setUserCitizenship} from 'reducers/common/userInfo/actions';

export default function fetchCitizenship(req: Request): Action {
    return setUserCitizenship(
        req.query.citizenship
            ? encodeURIComponent(req.query.citizenship).toUpperCase()
            : undefined,
    );
}
