import {ServerDataFetcherBag} from 'server/redux/types';

import {currenciesFetchActions} from 'reducers/common/currencies/actions';

import {CurrenciesService} from 'server/services/CurrenciesService/CurrenciesService';

import {geobaseService} from 'serviceProvider';

export async function fetchCurrencies({
    req,
    dispatch,
}: ServerDataFetcherBag): Promise<void> {
    const currenciesService =
        req.container.resolve<CurrenciesService>('currenciesService');

    try {
        const {geoId} = await geobaseService
            .provider(req?.container)
            .getUserGeoLocation();

        const currenciesInfo = await currenciesService.getCurrencyInfo(geoId);

        dispatch(currenciesFetchActions.success(currenciesInfo));
    } catch (e) {
        dispatch(currenciesFetchActions.failure());
    }
}
