import {Action} from 'typesafe-actions';

import {EXredirectHeaders} from 'server/constants/headers';

import {Request} from '@yandex-data-ui/core/lib/types';

import {setIsFromXredirect as setIsFromXredirectAction} from 'reducers/common/isFromXredirect/actions';

export default function setIsFromXredirect(req: Request): Action {
    return setIsFromXredirectAction(
        req.headers[EXredirectHeaders.X_YA_TRAVEL_IS_FROM_XREDIRECT] === '1',
    );
}
