module.exports = {
    // на уровне nginx эта ручка открыта только для localhost
    'GET /solomon/:service': {target: 'solomon', auth: 'disabled'},
    'POST /api/solomon': {target: 'apiController'},

    'GET /ping': {target: 'ping', auth: 'disabled'},
    'GET /3ds': {target: '3DSIFrameController', auth: 'disabled'},
    'GET /api/:project/:action': {
        target: 'apiController',
        afterAuth: [
            'userInfoMiddleware',
            'userNetworkMiddleware',
            'experimentsMiddleware',
            'jaegerApiMiddleware',
        ],
    },
    'POST /api/:project/:action': {
        target: 'apiController',
        afterAuth: [
            'userInfoMiddleware',
            'userNetworkMiddleware',
            'experimentsMiddleware',
            'jaegerApiMiddleware',
        ],
    },
    'GET /download/:project/:action/:voucherFileId': {
        target: 'apiController',
        afterAuth: [
            'userInfoMiddleware',
            'userNetworkMiddleware',
            'experimentsMiddleware',
            'jaegerApiMiddleware',
        ],
    },
    'PUT /api/:project/:action': {
        target: 'apiController',
        afterAuth: [
            'userInfoMiddleware',
            'userNetworkMiddleware',
            'experimentsMiddleware',
            'jaegerApiMiddleware',
        ],
    },
    'DELETE /api/:project/:action/:id': {
        target: 'apiController',
        afterAuth: [
            'userInfoMiddleware',
            'userNetworkMiddleware',
            'experimentsMiddleware',
            'jaegerApiMiddleware',
        ],
    },
    'DELETE /api/:project/:action': {
        target: 'apiController',
        afterAuth: [
            'userInfoMiddleware',
            'userNetworkMiddleware',
            'experimentsMiddleware',
            'jaegerApiMiddleware',
        ],
    },
    'GET /api/:project/:action/:param': {
        target: 'apiController',
        afterAuth: [
            'userInfoMiddleware',
            'userNetworkMiddleware',
            'experimentsMiddleware',
            'jaegerApiMiddleware',
        ],
    },
    'POST /api/:project/:action/:param': {
        target: 'apiController',
        afterAuth: [
            'userInfoMiddleware',
            'userNetworkMiddleware',
            'experimentsMiddleware',
            'jaegerApiMiddleware',
        ],
    },
    // tinyUrlRedirect
    'GET /:project(-)/:token': {
        target: 'apiController',
        afterAuth: ['jaegerPageMiddleware'],
    },
    'GET *': {
        target: 'renderServer',
        ui: true,
        beforeAuth: ['decodeUrlMiddleware'],
        afterAuth: [
            'incompatibleMiddleware',
            'userInfoMiddleware',
            'userNetworkMiddleware',
            'featuresMiddleware',
            'expressVaryMiddleware',
            'experimentsMiddleware',
            'jaegerPageMiddleware',
        ],
    },
};
