/* eslint-disable camelcase */
import {CurrencyType} from 'utilities/currency/CurrencyType';

export type TRatesMap = {[key in CurrencyType]?: number};

interface ICurrencyFormat {
    code: string;
    iso_code: string;
    name: string;
    template_whole: string;
}

interface ICodeToFormat {
    [key: string]: ICurrencyFormat;
}

interface ICurrencyName {
    name: string;
    name_in: string;
}

interface ICodeToNames {
    [key: string]: ICurrencyName;
}

export interface ICurrencyServerInfo {
    'country-base'?: string;
    available: string[];
    formats: ICodeToFormat;
    names: ICodeToNames;
    order: string[];
    rates: TRatesMap;
    selected?: CurrencyType;
}

export interface ICurrenciesInfo {
    nationalCurrency: CurrencyType;
    preferredCurrency: CurrencyType;
    availableCurrencies: CurrencyType[];
    currencyRates: TRatesMap;
}
