import {Readable} from 'stream';

import {IDependencies} from 'server/getContainerConfig';
import {
    ImageGeneratorApi,
    IGenerateImageQuery,
} from 'server/api/ImageGeneratorApi/ImageGeneratorApi';

export class ImageGeneratorService {
    private imageGeneratorApi: ImageGeneratorApi;

    constructor({imageGeneratorApi}: IDependencies) {
        this.imageGeneratorApi = imageGeneratorApi;
    }

    generate = async (query: IGenerateImageQuery): Promise<Readable> =>
        this.imageGeneratorApi.generate(query);

    ping = async (): Promise<string> => this.imageGeneratorApi.ping();
}
