import {
    TStoreTinyUrlService,
    TStoreTinyUrlServiceAnswer,
} from 'server/services/TinyUrlService/types/IStoreTinyUrlService';
import {
    TRestoreTinyUrlService,
    TRestoreTinyUrlServiceAnswer,
} from 'server/services/TinyUrlService/types/IRestoreTinyUrlService';

import {ILogger} from 'server/utilities/Logger';
import {unknownToErrorOrUndefined} from 'utilities/error';

import {IDependencies} from 'server/getContainerConfig';
import {TinyUrlApi} from 'server/api/TinyUrl/TinyUrlApi';

export class TinyUrlService {
    private logger: ILogger;
    private tinyUrlApi: TinyUrlApi;

    constructor({logger, tinyUrlApi}: IDependencies) {
        this.logger = logger;
        this.tinyUrlApi = tinyUrlApi;
    }

    async store(
        params: TStoreTinyUrlService,
    ): Promise<TStoreTinyUrlServiceAnswer> {
        try {
            const answer = await this.tinyUrlApi.store({
                url: params.url,
            });

            if (!('url' in answer.doc)) {
                throw new Error(answer.doc.message);
            }

            const token = answer.doc.token;

            return `https://${params.requestHostname}/-/${token}`;
        } catch (e) {
            this.logger.logError(
                'commonStoreTinyUrl',
                unknownToErrorOrUndefined(e),
            );

            throw e;
        }
    }

    async restore(
        params: TRestoreTinyUrlService,
    ): Promise<TRestoreTinyUrlServiceAnswer> {
        try {
            const answer = await this.tinyUrlApi.restore({
                token: params.token,
            });

            if (!('url' in answer.doc)) {
                throw new Error(answer.doc.message);
            }

            return answer.doc.url;
        } catch (e) {
            this.logger.logError(
                'commonRestoreTinyUrl',
                unknownToErrorOrUndefined(e),
            );

            throw e;
        }
    }
}
