import EAttributionField from 'server/utilities/DataStorage/AttributionData/types/IAttributionDataValues/EAttributionField';

import {
    WIZARD_FLAGS_QUERY_NAMES,
    WIZARD_REDIR_KEY_QUERY_NAMES,
    WIZARD_REQ_ID_QUERY_NAMES,
} from 'utilities/url/wizard/wizardQueryNames';

/**
 * Сопоставляет наши поля аттрибуции и query параметры, берет первый подходящий
 */
const mapFieldToQuery: Record<EAttributionField, string[]> = {
    [EAttributionField.UTM_SOURCE]: ['utm_source'],
    [EAttributionField.UTM_MEDIUM]: ['utm_medium'],
    [EAttributionField.UTM_CAMPAIGN]: ['utm_campaign'],
    [EAttributionField.UTM_TERM]: ['utm_term'],
    [EAttributionField.UTM_CONTENT]: ['utm_content'],

    [EAttributionField.GCLID]: ['gclid'],
    [EAttributionField.YCLID]: ['yclid'],
    [EAttributionField.FBCLID]: ['fbclid'],
    [EAttributionField.YTP_REFERER]: ['ytp_referer'],

    [EAttributionField.SERP_REQ_ID]: [
        ...WIZARD_REQ_ID_QUERY_NAMES,
        'serpReqId',
        'req_id',
    ],
    [EAttributionField.SERP_UUID]: ['serp_uuid'],
    [EAttributionField.SERP_TEST_ID]: ['test-id', 'serp_test_id'],
    [EAttributionField.FROM]: ['from'],

    [EAttributionField.PARTNER]: ['partner'],
    [EAttributionField.SUBPARTNER]: ['subpartner'],
    [EAttributionField.PARTNER_UID]: ['partner_uid'],

    [EAttributionField.WIZARD_FLAGS]: [...WIZARD_FLAGS_QUERY_NAMES],
    [EAttributionField.WIZARD_REDIR_KEY]: [...WIZARD_REDIR_KEY_QUERY_NAMES],

    [EAttributionField.USER_REGION]: ['userRegion'],
};

export default mapFieldToQuery;
