import {IAxiosRetryConfig} from 'axios-retry';

/**
 * Совместимый с axios интерфейс http-клиента
 */
export interface IRequestConfig {
    url?: string;
    method?:
        | 'get'
        | 'GET'
        | 'delete'
        | 'DELETE'
        | 'head'
        | 'HEAD'
        | 'options'
        | 'OPTIONS'
        | 'post'
        | 'POST'
        | 'put'
        | 'PUT'
        | 'patch'
        | 'PATCH';
    baseURL?: string;
    headers?: any;
    params?: any;
    data?: any;
    timeout?: number;
    withCredentials?: boolean;
    responseType?:
        | 'text'
        | 'arraybuffer'
        | 'blob'
        | 'document'
        | 'json'
        | 'stream';
    onUploadProgress?: (progressEvent: any) => void;
    onDownloadProgress?: (progressEvent: any) => void;
    maxContentLength?: number;
    validateStatus?: (status: number) => boolean;
    maxRedirects?: number;
    httpAgent?: any;
    httpsAgent?: any;
    convertResponseKeysToCamelCase?: boolean;
    paramsSerializer?: (params: any) => string;
    'axios-retry'?: IAxiosRetryConfig;
    withStatus?: boolean;
    signal?: AbortSignal;
}

export interface IResponse<T = void> {
    data: T;
    status: number;
    statusText: string;
    headers: any;
}

export interface IErrorResponse extends Error {
    code?: string;
    request?: any;
    response?: IResponse<any>;
}

export interface IHttpClient {
    request<T = any>(config: IRequestConfig): Promise<IResponse<T>>;
}
