import {
    Request,
    Response,
    CoreRequestHandler,
} from '@yandex-data-ui/core/lib/types';

import {TUserInfo} from 'reducers/common/commonReducerTypes';

export function authorize(
    target: unknown,
    propertyKey: string | symbol,
    descriptor: TypedPropertyDescriptor<CoreRequestHandler>,
): void {
    const originalFn = descriptor.value;

    if (typeof originalFn !== 'function') {
        throw new TypeError('requiredParams can decorate only functions');
    }

    descriptor.value = function (
        req: Request,
        res: Response,
    ): Promise<void> | void | undefined {
        const userInfo: TUserInfo =
            req.container.resolve<TUserInfo>('userInfo');

        if (!userInfo || !('uid' in userInfo) || !userInfo.uid) {
            res.status(401).send({
                statusCode: 'Unauthorized',
            });

            return;
        }

        return originalFn.call(this, req, res);
    };
}
