import _ from 'lodash';

import {AppRequestHandler} from '@yandex-data-ui/core/lib/types';

import {ILogger} from '../Logger';

export function logAction(
    target: any,
    propertyKey: string | symbol,
    descriptor: TypedPropertyDescriptor<AppRequestHandler>,
) {
    const originalFn = descriptor.value;
    if (typeof originalFn !== 'function') {
        throw new TypeError('logAction can only decorate functions');
    }

    descriptor.value = function (req, res) {
        const logger = req.container.resolve<ILogger>('logger');
        const className = _.get(target, 'constructor.name');
        logger.addExtra({
            controller: className,
            action: propertyKey.toString(),
        });
        return originalFn.call(this, req, res);
    };
}
