import once from 'lodash/once';

import {EProjectName} from 'constants/common';
import {URLs} from 'constants/urls';

const getBaseUrlsEntries = once(() =>
    Object.values(EProjectName)
        .map((p): [EProjectName, string] => [p, URLs[p]])
        .sort(
            ([, aBaseURL], [, bBaseURL]) => bBaseURL.length - aBaseURL.length,
        ),
);

/**
 * Возвращает имя проекта по pathname
 * При отсутствии совпадений возвращает EProjectNames.index
 * @param pathname
 */
export default function getProjectName(pathname: string): EProjectName {
    return (
        getBaseUrlsEntries().find(([, baseURL]) =>
            pathname.startsWith(baseURL),
        )?.[0] ?? EProjectName.INDEX
    );
}
