import {IAttributionMetaParams} from 'types/hotels/common/IAttribution';
import IAttributionData from 'server/utilities/DataStorage/AttributionData/types/IAttributionData';
import IUserData from 'server/utilities/DataStorage/UserData/types/IUserData';
import {IDebugPortalHost} from 'server/utilities/hotels/HotelsMetaParamsBuilder/types/IDebugPortalHost';

import AffiliateData from 'server/utilities/DataStorage/AffiliateData/AffiliateData';

import {IDependencies} from 'server/getContainerConfig';

export class HotelsMetaParamsBuilder {
    private readonly affiliateData: AffiliateData;
    private readonly attributionData: IAttributionData;
    private readonly userData: IUserData;

    private readonly requestHostname: string;
    private readonly isCrowdTestProxy: boolean;
    private readonly crowdTestHost: string | undefined;

    constructor({
        affiliateData,
        attributionData,
        userData,
        requestHostname,
        crowdTestHost,
        isCrowdTestProxy,
    }: IDependencies) {
        this.affiliateData = affiliateData;
        this.attributionData = attributionData;
        this.userData = userData;

        this.requestHostname = requestHostname;
        this.isCrowdTestProxy = isCrowdTestProxy;
        this.crowdTestHost = crowdTestHost;
    }

    getAttributionParams(): IAttributionMetaParams {
        const {attributionData, userData, affiliateData} = this;

        return {
            serpReqId: attributionData.getSerpReqId(),
            gclid: attributionData.getGclid(),
            yclid: attributionData.getYclid(),
            fbclid: attributionData.getFbclid(),
            userRegion: attributionData.getUserRegion(),
            ytpReferer: attributionData.getYtpReferer(),
            ...attributionData.getUtm(),
            metrikaClientId: userData.getMetrikaClientId(),
            metrikaUserId: userData.getMetrikaUserId(),
            ...affiliateData.getParams(),
        };
    }

    getDebugPortalHost(): IDebugPortalHost {
        const {requestHostname, isCrowdTestProxy, crowdTestHost} = this;

        if (requestHostname) {
            return {
                debugPortalHost: isCrowdTestProxy
                    ? crowdTestHost || requestHostname
                    : requestHostname,
            };
        }

        return {
            debugPortalHost: undefined,
        };
    }
}
