import {v4 as uuidV4} from 'uuid';

import {JAEGER_TRACER_OPTIONS} from 'server/constants/common';

import {Request} from '@yandex-data-ui/core/lib/types';

const {TRACER_DEBUG_TAG_NAME} = JAEGER_TRACER_OPTIONS;

function setJaegerDebugTag(req: Request): string | undefined {
    if (!req.rootSpan) {
        return undefined;
    }

    const forceDebugTag = req.utils.config.travelTracing.meta?.forceDebugTag;
    const canSetJaegetDebugId =
        forceDebugTag ||
        (req.userInfo && 'isStaff' in req.userInfo
            ? req.userInfo.isStaff
            : undefined);
    const jaegerDebugId = req.rootSpan.getBaggageItem(TRACER_DEBUG_TAG_NAME);

    if (canSetJaegetDebugId && !jaegerDebugId) {
        const tracerUuid = uuidV4();

        req.rootSpan.setTag(TRACER_DEBUG_TAG_NAME, tracerUuid);

        return tracerUuid;
    }

    return jaegerDebugId;
}

export default setJaegerDebugTag;
